<?php

/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Twenty_Nineteen
 * @since 1.0.0
 */

get_header();
?>

<?php while ( have_posts() ) : the_post(); ?>

<?php

$category = get_the_category();
$firstCategory = $category[0]->cat_name;
$category_id = $category[0]->term_taxonomy_id;


?>

<div class="tour_page left-sidebar customtrippage">
  <!--div class="tour_page_head" style="background-image: url(<?php echo get_the_post_thumbnail_url( $post_id, 'large' ); ?>)" -->
  <div class="tour_page_head">
      <div class="breadcrumbs">
          <div class="wrap">
              <div class="wrap_float">
                  <a href="<?php echo get_site_url(); ?>">Home</a>
                  <span class="separator">/</span>
                  <a href="<?php echo get_site_url(); ?>/travel-trip">Travel Trip</a>
              </div>
          </div>
      </div>
      <div class="header_content" id="head">
          <div class="wrap">
              <div class="wrap_float">
                  <div class="top-info">
                      <h1 class="country"><?php echo $firstCategory; ?></h1>
                      <p class="tour_title">
                          <?php the_title(); ?>
                      </p>
                      <div class="controls">
                          <div class="arrows" id="tour-head-slider-arrows">
                              <div class="arrow prev"></div>
                              <div class="arrow next"></div>
                          </div>
                      </div>
                  </div>
                  <div class="slider_wrap">
                      <div class="slider lightgallery" id="tour-head-slider">
                          <?php $slider_images = get_field('slider_images'); if(isset($slider_images)): foreach($slider_images as $simage): ?>
                          <a href="<?php echo $simage; ?>" class="slide">
                              <img src="<?php echo $simage; ?>" >
                          </a>
                          <?php endforeach; endif;  ?>
                      </div>
                  </div>
              </div>
          </div>
      </div>
  </div>
  <div class="tour_page_body">
      <div class="wrap">
          <div class="wrap_float">
              <div class="right_content sidebar">
                  <div class="navigation" id="sidebar-navigation">
                      <ul>
                          <li><a class="active" href="#head">Photo / Video</a></li>
                          <li><a href="#overview">Overview</a></li>
                          <?php if(!empty(get_field('included_section'))): ?>
                            <li><a href="#included">Included</a></li>
                          <?php endif; ?>
                          <?php if(!empty(get_field('location_iframe_url'))): ?>
                          <li><a href="#location">Location</a></li>
                          <?php endif; ?>
                          <li><a href="#hotels">Hotels</a></li>
                      </ul>
                  </div>
                  <a class="book-now button js-popup-open" data-href="#book-now">
                      <span>Request Quotes</span>
                  </a>
                  <a class="book-now button js-popup-open custoButton" data-href="#book-now2">
                      <span>Customize & Get Quotes</span>
                  </a>
              </div>
              <div class="left_content">
                <?php if(!empty(get_field('days'))): ?>
                  <div class="overview js-section content-block" id="overview">
                      <h2 class="title">Overview</h2>
                      <div class="description">
                          <?php the_content(); ?>
                      </div>
                      <div class="programm" id="programm-days">
                          
                        <?php $days = get_field('days'); if(isset($days)): $l=1; foreach($days as $day): ?>
                          <div class="day_item">
                              <div class="day_item-head <?php if($l==1){echo 'active';} ?> ">
                                  <div class="preview">
                                      <div class="image">
                                          <img src="<?php echo $day['day_icon']; ?>" alt="">
                                      </div>
                                      <div class="p">Place <?php echo $l; ?></div>
                                  </div>
                                  <div class="_title"><?php echo $day['day_title']; ?></div>
                                  <div class="element"></div>
                              </div>
                              <div class="day_item-body" <?php if($l==1): ?> style="display: block;" <?php endif; ?>>
                                  <div class="text">
                                      <?php echo $day['day_description']; ?>
                                  </div>
                                  <div class="images">
                                      <div class="scroll lightgallery">
                                        <?php
                                          $get_gallery = $day['day_gallery'];
                                          if(!empty($get_gallery)):
                                          foreach ($get_gallery as $ggla):
                                        ?>
                                          <a href="<?php echo $ggla; ?>" class="item">
                                              <div class="img">
                                                  <img src="<?php echo $ggla; ?>" alt="">
                                              </div>
                                          </a>
                                        <?php endforeach; endif; ?>
                                      </div>
                                  </div>
                              </div>
                          </div>
                          <?php $l++; endforeach; endif;  ?>

                      </div>
                  </div>
                  <?php endif; ?>



                  <?php if(!empty(get_field('included_section'))): ?>
                  <div class="included js-section content-block" id="included">
                      <h2 class="title">Included</h2>
                      <ul>
                          <?php
                            $included_section = get_field('included_section');
                            if(!empty($included_section)):
                            foreach ($included_section as $insection):
                          ?>
                          <li>
                              <span class="li_title"><?php echo $insection['title']; ?></span>
                              <span class="li_subtitle"><?php echo $insection['short_description']; ?></span>
                          </li>
                          <?php endforeach; endif; ?>
                      </ul>
                  </div>
                  <?php endif; ?>
                  <?php if(!empty(get_field('location_iframe_url'))): ?>
                  <div class="location js-section content-block" id="location">
                      <h3 class="title">Location</h3>
                      <div class="map">
                          <iframe src="<?php echo get_field('location_iframe_url'); ?>" width="100%" height="400" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
                      </div>
                  </div>
                  <?php endif; ?>

                  <?php if(!empty(get_field('hotels'))): ?>
                  <div class="overview js-section content-block" id="hotels">
                      <h2 class="title">Hotels</h2>
                      <div class="programm" id="programm-days">
                        <?php $hotels = get_field('hotels'); if(isset($hotels)): $l=1; foreach($hotels as $hotel): ?>
                          <div class="day_item">
                              <div class="day_item-head ">
                                  <div class="preview">
                                      <div class="image">
                                          <img src="<?php echo $hotel['hotel_banner']; ?>" alt="">
                                      </div>
                                  </div>
                                  <div class="_title"><?php echo $hotel['hotel_title']; ?></div>
                                  <div class="element"></div>
                              </div>
                              <div class="day_item-body" >
                                  <div class="text">
                                      <?php echo $hotel['hotel_description']; ?>
                                  </div>
                                  <div class="images">
                                      <div class="scroll lightgallery">
                                        <?php
                                          $get_gallery = $hotel['hotel_gallery'];
                                          if(!empty($get_gallery)):
                                          foreach ($get_gallery as $ggla):
                                        ?>
                                          <a href="<?php echo $ggla; ?>" class="item">
                                              <div class="img">
                                                  <img src="<?php echo $ggla; ?>" alt="">
                                              </div>
                                          </a>
                                        <?php endforeach; endif; ?>
                                      </div>
                                  </div>
                              </div>
                          </div>
                          <?php $l++; endforeach; endif;  ?>

                      </div>
                  </div>
                  <?php endif; ?>

                  <?php if(!empty(get_field('similar_packages'))): ?>
                  <div class="stories js-section content-block" id="stories">
                      <div class="title_wrap">
                          <h2 class="title">Similar Packages</h2>
                          <div class="link">
                              <a href="#">All Stories</a>
                          </div>
                      </div>
                      <div class="stries_slider">
                          <div class="scroll">
                            <?php $similars = get_field('similar_packages'); foreach($similars as $similar): ?>
                        <?php 
                              query_posts(array(
                                'post_type' => 'post',
                                'p' => $similar,
                              ));
                               
                              if ( have_posts() ) :  while ( have_posts() ) : the_post();
                              $categories = get_the_category();
                            ?>
                              <a href="<?php echo get_the_permalink(); ?>" class="story_item" style="background-image: url(<?php echo get_the_post_thumbnail_url( $post_id, 'large' ); ?>)">
                                  <div class="item_wrap">
                                      <div class="_content">
                                          <h3 class="country">
                                            <?php foreach ($categories as $category): ?>
                                              <?php echo $category->cat_name; ?>
                                            <?php endforeach; ?>
                                          </h3>
                                          <p class="text">
                                              <?php echo the_title(); ?>
                                          </p>
                                      </div>
                                  </div>
                                  <div class="shadow js-shadow"></div>
                              </a>
                              <?php $x++; endwhile;?>
                            <?php endif; ?> 
                            
                          <?php endforeach; ?>
                          <?php wp_reset_query(); ?>
                          </div>

                      </div>
                  </div>
                  <?php endif; ?>
              </div>
          </div>
      </div>
  </div>
</div>

<div class="popup book-now-popup" id="book-now">
  <div class="scroll">
      <div class="scroll_wrap">
          <div class="popup-head">
              <div class="title">Get Quote</div>
          </div>
          <div class="popup-body">
              <div class="tour-title">
                  <div class="img">
                      <img src="<?php echo get_the_post_thumbnail_url( $post_id, 'thumbnail' ); ?>" alt="">
                  </div>
                  <div class="tour-name">
                      <?php the_title(); ?>
                  </div>
              </div>
              <div class="form">
                <?php echo do_shortcode('[wpforms id="305" title="false"]'); ?>
              </div>
          </div>
      </div>
  </div>
  <div class="close"></div>
</div>

<div class="popup book-now-popup" id="book-now2">
  <div class="scroll">
      <div class="scroll_wrap">
          <div class="popup-head">
              <div class="title">Customize & Get Quotes</div>
          </div>
          <div class="popup-body">
              <div class="tour-title">
                  <div class="img">
                      <img src="<?php echo get_the_post_thumbnail_url( $post_id, 'thumbnail' ); ?>" alt="">
                  </div>
                  <div class="tour-name">
                      <?php the_title(); ?>
                  </div>
              </div>
              <div class="form">
                <?php echo do_shortcode('[wpforms id="307" title="false"]'); ?>
              </div>
          </div>
      </div>
  </div>
  <div class="close"></div>
</div>


<?php endwhile; ?>

<?php
get_footer();
?>


<?php
$placecheckbox = '';
$placecheckbox .= '<ul>';
$x = 0;
  query_posts(array(
    'post_type' => 'post',
    'cat'=>$category_id,
  ));
   
  if ( have_posts() ) :  while ( have_posts() ) : the_post();
  $categories = get_the_category();
?>

<?php $days = get_field('days'); if(isset($days)): $l=1; foreach($days as $day): ?>
<?php

  $placecheckbox .= '<li><input type="checkbox" id="myCheckbox'.$l.$x.'" value="'.$day['day_title'].'" class="selbox" /><label for="myCheckbox'.$l.$x.'"><img src="'.$day['day_icon'].'" />'.$day['day_title'].'</label></li>';

?>

<?php $l++; endforeach; endif;  ?>

<?php $x++; endwhile;?>
<?php endif; ?> 
<?php $placecheckbox .= '</ul>'; ?>
<?php wp_reset_query(); ?>



<script type="text/javascript">
  var placecheckbox = '<?php echo $placecheckbox; ?>';
  jQuery(".setcusotm").html(placecheckbox);
  setInterval(function(){
    var postid = <?php echo get_the_ID(); ?>;
    jQuery(".wpforms-form input[type=radio][value="+postid+"]").prop("checked",true);
  }, 5000);

  $('.selbox').click(function () {
      var valuearray = []
      $(".selbox:checked").each(function(){
          valuearray.push($(this).val());
      });
      var separator = ' || ';
      var implodedArray = valuearray.join(separator);
      jQuery(".seledplzce textarea").html(implodedArray);
      
  });
</script>
