<?php
/* Template Name: Travel */ 
$catid = ($_GET['catid']) ? $_GET['catid'] : '';
get_header();
?>

<div class="breadcrumbs">
    <div class="wrap">
        <div class="wrap_float">
            <a href="<?php echo get_site_url(); ?>">Home</a>
            <span class="separator">/</span>
            <?php the_title(); ?>
        </div>
    </div>
</div>
<div class="page default travel-list full-width page blog-list-page">
    <div class="wrap">
        <div class="wrap_float">
            <div class="page_head">
                <h1 class="title">
                    <?php the_title(); ?>
                </h1>
                <div class="filters">
                    <?php 
                        $clsit = get_categories(); 
                        ?>
                    <div class="select_wrap">

                        <select id="country">
                            <option value="">Select Country</option>
                            <?php foreach ($clsit as $cdata): ?>
                                <option <?php if($catid==$cdata->term_id): ?>Selected<?php endif; ?> value="<?php echo $cdata->term_id; ?>"><?php echo $cdata->name; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="page_body">
                <div class="wrap">
                    <div class="wrap_float">
                        <div class="posts">
                            <?php 
                              $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                              

                              query_posts(array(
                                'post_type' => 'post',
                                'paged' => $paged,
                                'cat'=>$catid,
                                'posts_per_page' => 30
                              ));
                               
                              if ( have_posts() ) :  while ( have_posts() ) : the_post();
                              $categories = get_the_category();
                            ?>
                            <a href="<?php echo get_the_permalink(); ?>" class="tour_item" style="background-image: url(<?php echo get_the_post_thumbnail_url( $post_id, 'large' ); ?>)">
                                <div class="tour_item_top">
                                    <p class="country">
                                        <?php foreach ($categories as $category): ?>
                                            <span><?php echo $category->cat_name; ?></span>
                                        <?php endforeach; ?>
                                    </p>
                                    
                                </div>
                                <div class="tour_item_bottom">
                                    <h3 class="_title"><?php echo the_title(); ?></h3>
                                    <div class="_info">
                                        <div class="_info_left">
                                            <?php if(!empty(get_field('trip_days'))): ?>
                                                <div class="cost"><?php echo get_field('trip_days'); ?> Days</div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="_info_right">
                                            <div class="rating-stars">
                                                <?php $rating = get_field('star-rating'); ?>
                                                <?php for ($x = 1; $x <= $rating; $x++): ?>
                                                    <div class="star filled"></div>
                                                <?php endfor; ?>
                                                <?php for ($x = 1; $x <= 5-$rating; $x++): ?>
                                                    <div class="star"></div>
                                                <?php endfor; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="shadow js-shadow"></div>
                            </a>
                            <?php $x++; endwhile;?>

                        </div>
                        <div class="row text-right ">
                          <div class="col-md-12 pagination">
                          <?php post_pagination();?> 
                          </div>
                        </div>
                        <?php endif; ?> 
                        <?php wp_link_pages(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
get_footer();
?>

<script type="text/javascript">
    $('#country').on('change', function(){
        var country_id = $(this).val()
        var site_url = "<?php echo get_site_url(); ?>/travel-trip";
        var set_var = "?catid="+country_id;
        if(country_id){
            var marge_url = site_url+set_var;
        }else{
            var marge_url = site_url;
        }
        window.location = marge_url;
    });
</script>
