<?php
/* Template Name: Blog */ 
get_header();
?>

<div class="breadcrumbs">
            <div class="wrap">
                <div class="wrap_float">
                    <a href="<?php echo get_site_url(); ?>">Home</a>
                    <span class="separator">/</span>
                    <?php the_title(); ?>
                </div>
            </div>
        </div>
        <div class="page blog-list-page full-width">
            <div class="wrap">
                <div class="wrap_float">
                    <div class="page_head">
                        <h1 class="title">
                            <?php the_title(); ?>
                        </h1>
                        <p class="subtitle">
                            <?php the_content(); ?>
                        </p>
                        <div class="filters">
                            <?php echo do_shortcode('[wpdreams_ajaxsearchlite]'); ?>
                        </div>
                    </div>
                    <div class="page_body">
                        <div class="blog-list">
                            <?php 
                              $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

                              query_posts(array(
                                'post_type' => 'blog',
                                'paged' => $paged,
                                'posts_per_page' => 50
                              ));
                               
                              if ( have_posts() ) :  while ( have_posts() ) : the_post();
                            ?>
                            <a href="<?php echo get_the_permalink(); ?>" class="blog_item" >
                                <div class="blog_item_top" style="background-image: url(<?php echo get_the_post_thumbnail_url( $post_id, 'large' ); ?>);">
                                    <div class="sq_parent">
                                      <div class="sq_wrap">
                                          <div class="sq_content">
                                            <div class="tags">
                                              <?php if(get_field('most_popular')): ?>
                                              <div class="tag green">
                                                  Most Popular
                                              </div>
                                              <?php endif; ?>
                                            </div>
                                            <h3 class="_title">
                                                <?php echo the_title(); ?>
                                            </h3>
                                          </div>
                                      </div>
                                      <div class="shadow js-shadow"></div>
                                    </div>
                                </div>
                                <div class="blog_item_bottom">
                                    <p class="text">
                                        <?php echo get_excerpt(130); ?>
                                    </p>
                                </div>
                            </a>
                            <?php $x++; endwhile;?>

                        </div>
                        <div class="row text-right ">
                          <div class="col-md-12 pagination">
                          <?php post_pagination();?> 
                          </div>
                        </div>
                        <?php endif; ?> 
                        <?php wp_link_pages(); ?>

                    </div>
                </div>
            </div>
        </div>
        
<?php
get_footer();
