<?php
 /* Template Name: Contact US */
get_header();
?>

        <div class="breadcrumbs">
            <div class="wrap">
                <div class="wrap_float">
                    <a href="<?php echo get_site_url(); ?>">Home</a>
                    <span class="separator">/</span>
                    <a href="">Contact Us</a>
                </div>
            </div>
        </div>
        <div class="page contacts-page full-width">
            <div class="wrap">
                <div class="wrap_float">
                    <div class="page_head">
                        <h1 class="title">
                           <?php the_field('contact_page_heading'); ?>
                        </h1>                        
                           <?php the_field('contact_page_content'); ?>                        
                     </div>
                     <div class="page_body">
                        <div class="contacts-left">
                           <div class="tel">
                              <a href="<?php the_field('contact_sec_number_url'); ?>"><?php the_field('contact_sec_number'); ?></a>
                              <p><?php the_field('contact_sec_number_text'); ?></p>
                           </div>
                           <div class="email">
                              <a href="<?php the_field('contact_sec_email_url'); ?>"><?php the_field('contact_sec_email'); ?></a>
                              <p><?php the_field('contact_sec_email_text'); ?></p>
                           </div>
                              <p class="address">
                                 <?php the_field('contact_sec_address'); ?>
                              </p>
                           <div class="socials social-links">
                              <a href="<?php echo get_theme_mod('facebook_url'); ?>" class="link facebook"><span></span></a>
                              <a href="<?php echo get_theme_mod('instagram_url'); ?>" class="link instagram"><span></span></a>
                              <a href="<?php echo get_theme_mod('pinterest_url'); ?>" class="link pinterest"><span></span></a>
                              <a href="<?php echo get_theme_mod('twitter_url'); ?>" class="link twitter"><span></span></a>
                              <a href="<?php echo get_theme_mod('youtube_url'); ?>" class="link youtube"><span></span></a>
                           </div>
                              <a class="btn button js-popup-open" data-href="<?php the_field('contact_us_button_url'); ?>"><?php the_field('contact_us_button'); ?></a>
                           </div>
                        <div class="contacts-right">
                           <div class="map">
                              <iframe src="<?php the_field('contact_sec_map'); ?>" width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
                           </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


<?php
get_footer();
?>