<?php
 /* Template Name: About US */ 
get_header();
?>    
    
        <div class="breadcrumbs">
            <div class="wrap">
                <div class="wrap_float">
                    <a href="<?php echo get_site_url(); ?>">Home</a>
                    <span class="separator">/</span>
                    <a href="">About Us</a>
                </div>
            </div>
        </div>
         <div class="page about-us-page">
            <div class="about-us">
                <div class="wrap">
                    <div class="wrap_float">
                        <h1 class="title"><?php the_field('about_sec_heading'); ?></h1>
                        <p class="description">
                           <?php the_field('about_sec_heading_text_1'); ?>
                        </p>
                        <p class="text">
                           <?php the_field('about_sec_heading_text_2'); ?>
                        </p>
                        <div class="image-block">
                            <img alt="" src="<?php the_field('about_sec_image'); ?>" style="width: 100%;">
                            <span><?php the_field('about_sec_image_span'); ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="statistics">
                <div class="wrap">
                    <div class="wrap_float">

                     <?php
                        if( have_rows('statistics_sec_box') ){
                           while ( have_rows('statistics_sec_box') ) { 
                              the_row(); 
                     ?>
                        <div class="statistics_item">
                           <div class="_value">
                              <?php echo get_sub_field('statistics_sec_value'); ?>
                           </div>
                           <h3 class="_title"><?php echo get_sub_field('statistics_sec_title'); ?></h3>
                              <p class="_text"><?php echo get_sub_field('statistics_sec_text'); ?></p>
                        </div>

                     <?php
                          }
                        } 
                     ?>                        

                    </div>
                </div>
            </div>

            <div class="team">
                <div class="wrap">
                    <div class="wrap_float">
                        <div class="team-head">
                            <h2 class="title"><?php the_field('team_sec_title'); ?></h2>
                            <div class="arrows" id="team_arrows">
                                <div class="arrow prev"></div>
                                <div class="arrow next"></div>
                            </div>
                        </div>
                        <div class="team-body">
                            <div class="slider">
                                <div class="team_slider" id="team_slider">

                                 <?php
                                    if( have_rows('team_sec_box') ){
                                       while ( have_rows('team_sec_box') ) { 
                                          the_row(); 
                                 ?>
                                    <div class="team_item">
                                        <div class="image">
                                            <div class="img_wrap">
                                                <img alt="" src="<?php echo get_sub_field('team_sec_image'); ?>">
                                            </div>
                                            <div class="socials">
                                                <div class="links">
                                                    <a class="facebook" href="<?php echo get_theme_mod('facebook_url'); ?>"></a>
                                                    <a class="instagram" href="<?php echo get_theme_mod('instagram_url'); ?>"></a>
                                                    <a class="pinterest" href="<?php echo get_theme_mod('pinterest_url'); ?>"></a>
                                                    <a class="twitter" href="<?php echo get_theme_mod('twitter_url'); ?>"></a>
                                                </div>
                                            </div>
                                        </div>
                                        <p class="name"><?php echo get_sub_field('team_sec_name'); ?></p>
                                        <p class="position"><?php echo get_sub_field('team_sec_position'); ?></p>
                                    </div>
                                 <?php
                                       }
                                    } 
                                 ?>           
                                    
                              </div>
                           </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="office">
                <div class="wrap">
                    <div class="wrap_float">
                        <h2 class="title"><?php the_field('office_sec_title'); ?></h2>
                        <div class="slider_wrap">
                            <div class="arrows" id="office_arrows">
                                <div class="arrow prev"></div>
                                <div class="arrow next"></div>
                            </div>
                            <div class="office_slider" id="office_slider">

                              <?php
                                 if( have_rows('office_sec_img_box') ){
                                    while ( have_rows('office_sec_img_box') ) { 
                                       the_row(); 
                              ?>

                                <div class="slide"><img alt="" src="<?php echo get_sub_field('office_sec__images'); ?>"></div>     

                              <?php
                                    }
                                 } 
                              ?>

                            </div>
                        </div>
                        <p class="text">
                           <?php the_field('office_sec_image_text'); ?>
                        </p>
                    </div>
                </div>
            </div>
         </div>


         


<?php
get_footer();
?>
