<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
	<meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="content-type" content="text/html;charset=UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
	<link rel="profile" href="https://gmpg.org/xfn/11">
    <link href="https://fonts.googleapis.com/css?family=Nunito:400,700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Prata&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/style.css">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_template_directory_uri(); ?>/assets/img/favicons/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo get_template_directory_uri(); ?>/assets/img/favicons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo get_template_directory_uri(); ?>/assets/img/favicons/favicon-16x16.png">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo get_template_directory_uri(); ?>/assets/img/favicons/android-chrome-192x192.png">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo get_template_directory_uri(); ?>/assets/img/favicons/android-chrome-512x512.png">
    <link rel="icon" type="image/png" href="<?php echo get_template_directory_uri(); ?>/assets/img/favicons/favicon-32x32.png" sizes="32x32">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo get_template_directory_uri(); ?>/assets/img/favicons/favicon.ico">
    <meta name="msapplication-TileColor" content="#151515">
    <meta name="theme-color" content="#151515">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/developer.css">

<?php wp_head(); ?>

</head>

<body <?php body_class(); ?> data-theme="light">

   <div class="container">
    <?php if( is_front_page() && is_home()): ?>
        <div class="top_panel">
    <?php else: ?>
        <div class="top_panel inversion">
    <?php endif; ?>
        
            <div class="wrap">
                <div class="wrap_float">
                    <div class="left">
                        
                        <?php if( is_front_page() ): ?>
                        <a href="<?php echo site_url(); ?>" class="logo">
                            <?php 
                                $custom_logo_id = get_theme_mod( 'custom_logo' );
                                $custom_logo_url = wp_get_attachment_image_url( $custom_logo_id , 'full' );
                                echo '<img src="' . esc_url( $custom_logo_url ) . '"  class="light-version-logo">';                 
                            ?>                           
                        </a>
                        <?php else: ?>
                        <a href="<?php echo site_url(); ?>" class="logo">
                            <img src="<?php echo get_field('dark_logo', 'option'); ?>"  class="light-version-logo">                         
                        </a>
                        <?php endif; ?>
                    </div>
                    <div class="menu_wrap" id="menu_wrap">
                        <div class="scroll">
                            <div class="center">
                                <div class="menu">
                                    <ul>
                                        <?php
                                            wp_nav_menu(
                                                array(
                                                    'container'  => 'ul',
                                                    'menu_class' => '', 
                                                    'menu_id' => '', 
                                                    'menu' => 'top-menu',
                                                    'walker'     => new Bootstrap_Walker_Nav_Menu()
                                                )
                                            );
                                        ?>     
                                    </ul>

                                    <div class="mobile_content">
                                        <div class="tel">
                                            <a href="<?php echo get_theme_mod('mobile_content_number_url'); ?>"><?php echo get_theme_mod('mobile_content_number'); ?></a>
                                            <p><?php echo get_theme_mod('mobile_content_text'); ?></p>
                                        </div>
                                        <div class="social">
                                            <a href="<?php echo get_theme_mod('facebook_url'); ?>" class="link facebook"><span></span></a>
                                            <a href="<?php echo get_theme_mod('instagram_url'); ?>" class="link instagram"><span></span></a>
                                            <a href="<?php echo get_theme_mod('pinterest_url'); ?>" class="link pinterest"><span></span></a>
                                            <a href="<?php echo get_theme_mod('twitter_url'); ?>" class="link twitter"><span></span></a>
                                            <a href="<?php echo get_theme_mod('youtube_url'); ?>" class="link youtube"><span></span></a>
                                        </div>
                                    </div>


                                </div>
                                <div class="close" id="menu-close">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                </div>
                            </div>
                            
                            <div class="right">
                                <a class="favorites-count" title="Favourites" href="<?php echo get_theme_mod('sidebar_favourites_url'); ?>">
                                    <div class="_counter"><?php echo get_theme_mod('sidebar_counter_title'); ?></div>
                                    <div class="_text"><?php echo get_theme_mod('sidebar_text'); ?></div>
                                </a>
                            </div>
                            
                        </div>
                    </div>
                    <div class="mobile_btn" id="mobile_btn">
                        <span></span>
                        <span></span>
                        <span></span>
                    </div>
                </div>
            </div>
        </div>
      

