<?php
/**
 * The template for displaying the 404 template in the Twenty Twenty theme.
 *
 * @package WordPress
 * @subpackage Twenty_Twenty
 * @since 1.0.0
 */

get_header();
?>

<div class="container">
        <div class="page_404">
            <div class="cover" data-game="torch"></div>
            <div class="room" data-game="room"></div>
            <div class="wrap">
                <div class="wrap_float">
                    <a class="logo" href="/"></a>
                    <div class="page_wrap">
                        <div class="top">
                            <p class="error">404</p>
                            <p class="error_text">It looks like you got lost…</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
 <div class="modal_search" id="modal_search">
        <div class="close"></div>
        <div class="search-tour">
            <div class="wrap">
                <div class="wrap_float">
                    <div class="search-form">
                        <div class="destination-col">
                            <div class="label">
                                Destination
                            </div>
                            <div class="select_wrap">
                                <select>
                                    <option value="Destination" disabled selected>Destination</option>
                                    <option value="United States">United States</option>
                                    <option value="United Kingdom">United Kingdom</option>
                                    <option value="Afghanistan">Afghanistan</option>
                                    <option value="Albania">Albania</option>
                                    <option value="Algeria">Algeria</option>
                                    <option value="American Samoa">American Samoa</option>
                                    <option value="Andorra">Andorra</option>
                                    <option value="Angola">Angola</option>
                                    <option value="Anguilla">Anguilla</option>
                                    <option value="Antarctica">Antarctica</option>
                                    <option value="Antigua and Barbuda">Antigua and Barbuda</option>
                                    <option value="Argentina">Argentina</option>
                                    <option value="Armenia">Armenia</option>
                                    <option value="Aruba">Aruba</option>
                                    <option value="Australia">Australia</option>
                                    <option value="Austria">Austria</option>
                                    <option value="Azerbaijan">Azerbaijan</option>
                                    <option value="Bahamas">Bahamas</option>
                                    <option value="Bahrain">Bahrain</option>
                                    <option value="Bangladesh">Bangladesh</option>
                                    <option value="Barbados">Barbados</option>
                                    <option value="Belarus">Belarus</option>
                                    <option value="Belgium">Belgium</option>
                                    <option value="Belize">Belize</option>
                                    <option value="Benin">Benin</option>
                                    <option value="Bermuda">Bermuda</option>
                                    <option value="Bhutan">Bhutan</option>
                                    <option value="Bolivia">Bolivia</option>
                                    <option value="Bosnia and Herzegovina">Bosnia and Herzegovina</option>
                                    <option value="Botswana">Botswana</option>
                                    <option value="Bouvet Island">Bouvet Island</option>
                                    <option value="Brazil">Brazil</option>
                                    <option value="British Indian Ocean Territory">British Indian Ocean Territory</option>
                                    <option value="Brunei Darussalam">Brunei Darussalam</option>
                                    <option value="Bulgaria">Bulgaria</option>
                                </select>
                            </div>
                        </div>
                        <div class="date-col">
                            <div class="label">
                                Check In
                            </div>
                            <div class="date_div">
                                <input class="js_calendar desctop-input" type="text">
                                <input class="mobile-input" type="date">
                                <div class="day">
                                    21
                                </div>
                                <div class="date_div_right">
                                    <div class="month">
                                        December
                                    </div>
                                    <div class="year">
                                        2019
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="date-col">
                            <div class="label">
                                Check Out
                            </div>
                            <div class="date_div">
                                <input class="js_calendar desctop-input" type="text">
                                <input class="mobile-input" type="date">
                                <div class="day">
                                    21
                                </div>
                                <div class="date_div_right">
                                    <div class="month">
                                        December
                                    </div>
                                    <div class="year">
                                        2019
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="num-col">
                            <div class="label">
                                Aduld
                            </div>
                            <div class="num_wrap">
                                <div class="buttons">
                                    <button class="plus"></button>
                                    <button class="minus"></button>
                                </div>
                                <input class="val js_num" max="99" min="0" type="number" value="3">
                            </div>
                        </div>
                        <div class="num-col last">
                            <div class="label">
                                Children
                            </div>
                            <div class="num_wrap">
                                <div class="buttons">
                                    <button class="plus"></button>
                                    <button class="minus"></button>
                                </div>
                                <input class="val js_num" max="99" min="0" type="number" value="3">
                            </div>
                        </div>
                        <button class="btn button"><span>Search</span></button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="overlay" id="overlay"></div>

    <!-- Popups -->
    <div class="popup login" id="login">
        <div class="scroll">
            <div class="scroll_wrap">
                <div class="popup-head">
                    <div class="title">
                        Sign In
                    </div>
                    <a class="link js-popup-open" data-href="#registration">Sign Up</a>
                </div>
                <div class="popup-body">
                    <div class="subtitle">
                        Use the e-mail and password that you specified when registering on the site
                    </div>
                    <div class="form">
                        <input class="input" placeholder="Login" type="text">
                        <input class="input" placeholder="Password" type="text">
                        <button class="submit button">Sign In</button>
                        <a class="link" href="#">Forgot password?</a>
                    </div>
                </div>
                <div class="popup-foot">
                    <p>Login via social networks</p>
                    <div class="social-links">
                        <a class="link facebook" href="#"><span></span></a>
                        <a class="link twitter" href="#"><span></span></a>
                    </div>
                </div>
            </div>
        </div>
        <div class="close"></div>
    </div>

    <div class="popup registration" id="registration">
        <div class="scroll">
            <div class="scroll_wrap">
                <div class="popup-head">
                    <div class="title">
                        Sign Up
                    </div>
                    <a class="link js-popup-open" data-href="#login">Sign In</a>
                </div>
                <div class="popup-body">
                    <div class="subtitle">
                        Fill in the registration form and save your favorite tours, synchronize them on all devices
                    </div>
                    <div class="form">
                        <input class="input" placeholder="Username" type="text">
                        <input class="input" placeholder="Name" type="text">
                        <input class="input" placeholder="Surename" type="text">
                        <input class="input" placeholder="Email" type="email">
                        <input class="input" placeholder="Password" type="password">
                        <input class="input" placeholder="Password Repeat" type="password">
                        <button class="submit button js-submit">Registration</button>
                    </div>
                </div>
                <div class="popup-foot">
                    <p>Sign Up via social networks</p>
                    <div class="social-links">
                        <a class="link facebook" href="#"><span></span></a>
                        <a class="link twitter" href="#"><span></span></a>
                    </div>
                </div>
            </div>
        </div>
        <div class="close"></div>
    </div>

    <div class="popup forgot-pass" id="recovery-pass">
        <div class="scroll">
            <div class="scroll_wrap">
                <div class="popup-head">
                    <div class="title">
                        Forgot password?
                    </div>
                </div>
                <div class="popup-body">
                    <div class="subtitle">
                        Use the e-mail and password that you specified when registering on the site
                    </div>
                    <div class="form">
                        <input class="input" placeholder="Email" type="email">
                        <button class="submit button js-submit">Reset password</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="close"></div>
    </div>

    <div class="popup profile-setting" id="profile-setting">
        <div class="scroll">
            <div class="scroll_wrap">
                <div class="select-userpic">
                    <div class="userpic">
                        V
                    </div>
                    <div class="select">
                        <input id="profile-pic" type="file">
                        <label for="profile-pic">Select photo</label>
                    </div>
                </div>
                <div class="popup-head">
                    <div class="title">
                        Setting
                    </div>
                </div>
                <div class="popup-body">
                    <div class="form">
                        <input class="input" placeholder="Username" type="text" value="Victor777">
                        <input class="input" placeholder="Name" type="text" value="Victor">
                        <input class="input" placeholder="Surename" type="text" value="Shibut">
                        <input class="input" placeholder="Email" type="email" value="test@test.com">
                        <div class="label">
                            Change password
                        </div>
                        <input class="input" placeholder="Current password" type="password">
                        <input class="input" placeholder="Enter new password" type="password">
                        <input class="input" placeholder="New password repeat" type="password">
                        <div class="label">
                            Authorization through social networks
                        </div>
                        <div class="social-links">
                            <a class="link facebook active" href="#"><span></span></a>
                            <a class="link twitter" href="#"><span></span></a>
                        </div>
                        <button class="submit button js-submit">Save Setting</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="close"></div>
    </div>

    <div class="popup contact-us" id="contact-us">
        <div class="scroll">
            <div class="scroll_wrap">
                <div class="popup-head">
                    <div class="title">
                        Contact Us
                    </div>
                </div>
                <div class="popup-body">
                    <div class="subtitle">
                        But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain
                    </div>
                    <div class="form">
                        <input class="input" placeholder="Name" type="text">
                        <input class="input" placeholder="Email" type="email">
                        <input class="input" placeholder="Phone" type="text">
                        <textarea class="textarea" placeholder="Your Massage"></textarea>
                        <button class="submit button js-submit">Send Massage</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="close"></div>
    </div>

    <div class="popup book-now-popup" id="book-now">
        <div class="scroll">
            <div class="scroll_wrap">
                <div class="popup-head">
                    <div class="title">
                        Book Now
                    </div>
                </div>
                <div class="popup-body">
                    <div class="tour-title">
                        <div class="img">
                            <img alt="" src="img/tour-item-3.jpg">
                        </div>
                        <div class="tour-name">
                            Tour to the Arctic is an exotic journey on the verge of extreme
                        </div>
                    </div>
                    <div class="tour-info">
                        <div class="col">
                            <div class="label">
                                Check In
                            </div>
                            <div class="date">
                                <div class="day">
                                    09
                                </div>
                                <div class="month">
                                    May
                                </div>
                                <div class="year">
                                    2019
                                </div>
                            </div>
                            <div class="label">
                                Aduld: <span>3</span>
                            </div>
                        </div>
                        <div class="col">
                            <div class="label">
                                Check Out
                            </div>
                            <div class="date">
                                <div class="day">
                                    09
                                </div>
                                <div class="month">
                                    May
                                </div>
                                <div class="year">
                                    2019
                                </div>
                            </div>
                            <div class="label">
                                Children: <span>0</span>
                            </div>
                        </div>
                    </div>
                    <div class="form">
                        <input class="input" placeholder="Your First Name" type="text">
                        <input class="input" placeholder="Your Last Name" type="text">
                        <input class="input" placeholder="Your Email" type="email">
                        <input class="input" placeholder="Your Number Phone" type="tel">
                        <textarea class="textarea" placeholder="Where are your address?"></textarea>
                        <textarea class="textarea" placeholder="Note:"></textarea>
                        <button class="submit button js-submit">Book Now | <b>$356</b></button>
                    </div>
                </div>
            </div>
        </div>
        <div class="close"></div>
    </div>

    <div class="popup success-popup" id="contact-us-success">
        <div class="scroll">
            <div class="scroll_wrap">
                <div class="popup-head">
                    <div class="title">
                        Success
                    </div>
                </div>
                <div class="popup-body">
                    <div class="subtitle">
                        Your message was successfully sent. We will contact you shortly
                    </div>
                </div>
            </div>
        </div>
        <div class="close"></div>
    </div>





<?php
get_footer();
?>
